# API路由
from fastapi import APIRouter
from .customers import router as customers_router
from .servers import router as servers_router
from .socks5 import router as socks5_router
from .domains import router as domains_router
from .nodes import router as nodes_router
from .subscribers import router as subscribers_router
from .subscribe import router as subscribe_router
from .auth import router as auth_router
from .dashboard import router as dashboard_router
from .license import router as license_router
from .logs import router as logs_router

api_router = APIRouter()

api_router.include_router(auth_router, prefix="/auth", tags=["认证"])
api_router.include_router(license_router, prefix="/license", tags=["授权管理"])
api_router.include_router(dashboard_router, prefix="/dashboard", tags=["仪表盘"])
api_router.include_router(customers_router, prefix="/customers", tags=["客户管理"])
api_router.include_router(servers_router, prefix="/servers", tags=["服务器管理"])
api_router.include_router(socks5_router, prefix="/socks5", tags=["SK5管理"])
api_router.include_router(domains_router, prefix="/domains", tags=["域名管理"])
api_router.include_router(nodes_router, prefix="/nodes", tags=["节点管理"])
api_router.include_router(subscribers_router, prefix="/subscribers", tags=["订阅用户"])
api_router.include_router(subscribe_router, prefix="/subscribe", tags=["订阅"])
api_router.include_router(logs_router, tags=["日志管理"])



