"""
通用Schema
"""
from typing import Generic, TypeVar, Optional, List
from pydantic import BaseModel

T = TypeVar("T")


class ResponseModel(BaseModel, Generic[T]):
    """通用响应模型"""
    code: int = 0
    message: str = "success"
    data: Optional[T] = None


class PaginatedResponse(BaseModel, Generic[T]):
    """分页响应模型"""
    items: List[T]
    total: int
    page: int
    page_size: int
    pages: int


class MessageResponse(BaseModel):
    """消息响应"""
    message: str


class TestResult(BaseModel):
    """测试结果"""
    success: bool
    message: str
    latency: Optional[int] = None
    region: Optional[str] = None
    extra: Optional[dict] = None


class IPCheckResult(BaseModel):
    """IP检测结果"""
    ip: str
    country: str = ""
    country_code: str = ""
    region: str = ""
    city: str = ""
    isp: str = ""
    org: str = ""
    as_name: str = ""
    # IP类型
    ip_type: str = "unknown"  # residential/datacenter/mobile/proxy
    is_proxy: bool = False
    is_vpn: bool = False
    is_datacenter: bool = False
    is_residential: bool = False
    # TikTok评分
    tiktok_score: int = 0
    tiktok_risk: str = "unknown"  # low/medium/high
    risk_reasons: List[str] = []

