"""
域名Schema
"""
from datetime import datetime
from typing import Optional, List
from pydantic import BaseModel, Field

from ..models.domain import SSLStatus


class DomainBase(BaseModel):
    """域名基础字段"""
    domain: str = Field(..., min_length=1, max_length=255, description="域名")
    remark: Optional[str] = Field(None, description="备注")


class DomainCreate(DomainBase):
    """创建域名"""
    customer_id: Optional[int] = Field(None, description="关联客户ID")


class DomainUpdate(BaseModel):
    """更新域名"""
    domain: Optional[str] = Field(None, min_length=1, max_length=255)
    remark: Optional[str] = None


class DomainResponse(BaseModel):
    """域名响应"""
    id: int
    customer_id: Optional[int]
    customer_name: Optional[str] = None
    domain: str
    ssl_status: SSLStatus
    ssl_expire_at: Optional[datetime]
    remark: Optional[str]
    created_at: datetime
    
    class Config:
        from_attributes = True


class DomainListResponse(BaseModel):
    """域名列表响应"""
    items: List[DomainResponse]
    total: int




